function varargout = WUM(varargin)
% WUM MATLAB code for WUM.fig
%      WUM, by itself, creates a new WUM or raises the existing
%      singleton*.
%
%      H = WUM returns the handle to a new WUM or the handle to
%      the existing singleton*.
%
%      WUM('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in WUM.M with the given input arguments.
%
%      WUM('Property','Value',...) creates a new WUM or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before WUM_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to WUM_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help WUM

% Last Modified by GUIDE v2.5 29-May-2014 22:17:19

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @WUM_OpeningFcn, ...
                   'gui_OutputFcn',  @WUM_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before WUM is made visible.
function WUM_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to WUM (see VARARGIN)

% Choose default command line output for WUM
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes WUM wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = WUM_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --------------------------------------------------------------------
function File_Callback(hObject, eventdata, handles)
% hObject    handle to File (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Processing_Callback(hObject, eventdata, handles)
% hObject    handle to Processing (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function WUM_Callback(hObject, eventdata, handles)
if ~isfield( handles, 'im_original' )
return
end
    if exist('var.mat','file')==2 
    load('var.mat','t','W');
    handles.W=str2double(W);
    handles.t=str2double(t);
    else
    handles.W=1;
    handles.t=1;
    end
r=size(size(handles.im_original));
if r(2)<=2
    handles.outIm=WSharpening(handles.im_original,handles.W,handles.t);
else
    handles.outIm=WSharp_color(handles.im_original,handles.W,handles.t);
end
imshow(handles.outIm,'Parent',handles.sharIm);
if r(2)<=2
    str=['New Image Sharpness is ' num2str(estimate_sharpness(double(handles.outIm)))];
set(handles.text6,'String',str);
else
set(handles.text6,'String','');
end


guidata(hObject, handles);


% hObject    handle to WUM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Load_Callback(hObject, eventdata, handles)
[FileName, PathName] = uigetfile('*.*');
if PathName==0, return; end
Name = fullfile(PathName,FileName);  
handles.im_original=imread(Name);
r=size(size(handles.im_original));
colormap(gray(255))
 set(handles.orgIm,'HandleVisibility','ON');
axes(handles.orgIm);
image(handles.im_original);
 axis equal;
 axis tight;
 axis off;
set(handles.orgIm,'HandleVisibility','OFF');
if r(2)<=2
    str=['Image Sharpness is ' num2str(estimate_sharpness(double(handles.im_original)))];
set(handles.text5,'String',str);
else
set(handles.text5,'String','');
end
guidata(hObject, handles);

% hObject    handle to Load (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Save_Callback(hObject, eventdata, handles)
if isfield( handles, 'outIm' )    
[FileName, PathName] = uiputfile('*.tif', 'Save As');
if PathName==0, return; end 
Name = fullfile(PathName,FileName);  
imwrite(handles.outIm, Name);
end

% hObject    handle to Save (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Preferences_Callback(hObject, eventdata, handles)
% hObject    handle to Preferences (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Help_Callback(hObject, eventdata, handles)
% hObject    handle to Help (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Options_Callback(hObject, eventdata, handles)
run('Options.m')
% hObject    handle to Options (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function About_Callback(hObject, eventdata, handles)
openfig('About.fig')
% hObject    handle to About (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
